<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Company;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class CompanyController extends Controller
{
    public function changeWebsiteStatus(Request $request)
    {
        $request->validate([
            'status' => 'required|integer',
        ]);

        $company = Company::find(1);
        if (!$company) {
            return response()->json([
                'status' => 'error',
                'message' => "Can't find the data!",
            ], 404);
        }

        $company->website_status = $request->status;
        if ($company->save()) {
            return response()->json(['status' => 'done', 'message' => "Website-Status is updated successfully."], 200);
        }

        return response()->json(['status' => 'error', 'message' => "Failed to update Status!"], 500);
    }

    public function manageCompany()
    {
        $company = Company::select('id', 'company_icon', 'company_logo', 'company_footer_logo', 'company_name', 'alert_message', 'footer_content_visibility', 'footer_content')->findOrFail(1);
        $company->encrypted_id = Crypt::encrypt($company->id);

        $main_page = "settings";
        $currentPage = "company";
        return view('admin.manage_company', compact('company', 'main_page', 'currentPage'));
    }

    public function manageContact()
    {
        $contact = Company::select('id', 'phone', 'whatsapp_phone', 'alternate_phone', 'email', 'alternate_email', 'footer_location', 'availability', 'location', 'alternate_location', 'map_link_visibility', 'map_link')->findOrFail(1);
        $contact->encrypted_id = Crypt::encrypt($contact->id);

        $main_page = "settings";
        $currentPage = "contact";
        return view('admin.manage_contact', compact('contact', 'main_page', 'currentPage'));
    }

    public function manageSocials()
    {
        $socials = Company::select('id', 'socials_visibility', 'facebook_url', 'x_url', 'linkedin_url', 'youtube_url', 'instagram_url', 'telegram_url', 'whatsapp_url')->findOrFail(1);
        $socials->encrypted_id = Crypt::encrypt($socials->id);

        $main_page = "settings";
        $currentPage = "socials";
        return view('admin.manage_socials', compact('socials', 'main_page', 'currentPage'));
    }

    public function editCompany(Request $request)
    {
        $request->validate([
            'company_name' => 'required|string',
        ], [
            'company_name.required' => 'Comapny Name is required!',
            'company_name.string' => 'Comapny Name should be string!',
        ]);

        $id = Crypt::decrypt($request->company);
        $company = Company::findOrFail($id);
        $company->company_name = $request->company_name;
        $company->alert_message = $request->alert_message;
        $company->footer_content_visibility = $request->footer_content_visibility;
        if ($request->footer_content_visibility == 'yes') {
            $company->footer_content = $request->footer_content;
        }

        $path = 'images/company/';
        if ($request->hasFile('company_icon')) {
            $filePath = $this->storeImage($request->file("company_icon"), $path, $company->company_icon);
            $company->company_icon = $filePath;
        }
        if ($request->hasFile('company_logo')) {
            $filePath = $this->storeImage($request->file("company_logo"), $path, $company->company_logo);
            $company->company_logo = $filePath;
        }
        if ($request->hasFile('company_footer_logo')) {
            $filePath = $this->storeImage($request->file("company_footer_logo"), $path, $company->company_footer_logo);
            $company->company_footer_logo = $filePath;
        }

        if ($company->save()) {
            $request->session()->flash('success', 'Company data is updated Successfully!');
            return redirect()->route('manage.company');
        }

        $request->session()->flash('error', 'Updation Error!');
        return redirect()->route('edit.company', $request->company);
    }

    public function editContact(Request $request)
    {
        // $request->validate([
        //     'phone' => 'required|numeric',
        //     'mail' => 'required|email',
        // ], [
        //     'phone.required' => 'Phone Number is required!',
        //     'phone.numeric' => 'Phone Number should be numeric format!',
        //     'mail.required' => 'E-Mail is required!',
        //     'mail.email' => 'Invalid E-Mail!',
        // ]);

        $id = Crypt::decrypt($request->contact);
        $contact = Company::findOrFail($id);
        $contact->phone = $request->phone;
        $contact->whatsapp_phone = $request->whatsapp_phone;
        $contact->alternate_phone = $request->alternate_phone;
        $contact->email = $request->mail;
        $contact->alternate_email = $request->alternate_email;
        $contact->footer_location = $request->footer_location;
        $contact->availability = htmlspecialchars($request->availability);
        $contact->location = htmlspecialchars($request->location);
        $contact->alternate_location = htmlspecialchars($request->alternate_location);
        $contact->map_link_visibility = $request->map_link_visibility;
        if ($request->map_link_visibility == 'yes') {
            $contact->map_link = htmlspecialchars($request->map_link);
        }

        if ($contact->save()) {
            $request->session()->flash('success', 'Contact data is updated Successfully!');
            return redirect()->route('manage.contact');
        }

        $request->session()->flash('error', 'Updation Error!');
        return redirect()->route('edit.contact', $request->contact);
    }

    public function editSocials(Request $request)
    {
        $id = Crypt::decrypt($request->socials);
        $socials = Company::findOrFail($id);
        $socials->facebook_url = $request->facebook_url;
        $socials->x_url = $request->x_url;
        $socials->linkedin_url = $request->linkedin_url;
        $socials->youtube_url = $request->youtube_url;
        $socials->instagram_url = $request->instagram_url;
        $socials->telegram_url = $request->telegram_url;
        $socials->whatsapp_url = $request->whatsapp_url;

        if ($socials->save()) {
            $request->session()->flash('success', 'Socials data is updated Successfully!');
            return redirect()->route('manage.socials');
        }

        $request->session()->flash('error', 'Updation Error!');
        return redirect()->route('edit.socials', $request->socials);
    }

    public function getCompanyData()
    {
        return Company::findOrFail(1);
    }
}
