<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Features;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class FeaturesController extends Controller
{
    public function manageFeatures()
    {
        $features = Features::select('id', 'position_order', 'feature_headline', 'feature_image', 'status')->get();
        foreach ($features as $feature) {
            $feature->encrypted_id = Crypt::encrypt($feature->id);
        }
        $currentPage = "manage_features";
        $model = Crypt::encrypt('Features');
        return view('admin.manage_features', ['featuresData' => $features, 'model' => $model, 'currentPage' => $currentPage]);
    }

    public function addFeature(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'feature_headline' => 'required|string',
            ]);

            $feature_order = Features::max('position_order');
            $position_order = ($feature_order !== null) ? $feature_order + 1 : 1;

            $feature = [
                'position_order' => $position_order,
                'feature_headline' => $request->feature_headline,
                'description' => htmlspecialchars($request->description, ENT_QUOTES),
            ];

            if (!empty($request->file('feature_image'))) {
                $path = 'images/features/';
                $filePath = $this->storeImage($request->file('feature_image'), $path);
                $feature['feature_image'] = $filePath;
            }

            if (Features::create($feature)) {
                $request->session()->flash('success', 'Feature is inserted Successfully!');
                return redirect()->route('manage.features');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.feature');
            }
        } else {
            $currentPage = "manage_features";
            return view('admin.feature-ops', ['currentPage' => $currentPage]);
        }
    }

    public function editFeature(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'feature_headline' => 'required|string',
            ]);

            $id = Crypt::decrypt($request->feature);
            $feature = Features::findOrFail($id);
            $feature->feature_headline = $request->feature_headline;
            $feature->description = htmlspecialchars($request->description, ENT_QUOTES);

            if (!empty($request->file('feature_image'))) {
                $path = 'images/features/';
                $filePath = $this->storeImage($request->file("feature_image"), $path, $feature->feature_image);
                $feature->feature_image = $filePath;
            }

            if ($feature->save()) {
                $request->session()->flash('success', 'Feature is updated Successfully!');
                return redirect()->route('manage.features');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.feature', $request->feature);
            }
        } else {
            $id = Crypt::decrypt($request->feature);
            $feature = Features::where('id', $id)->firstOrFail();
            $feature->encrypted_id = $request->feature;
            $currentPage = "manage_features";
            return view('admin.feature-ops', ["feature" => $feature, 'currentPage' => $currentPage]);
        }
    }
}
