<?php

namespace App\Http\Controllers;

use App\Models\Admin\Company;
use Illuminate\Http\Request;

class WebsiteController extends Controller
{
    public function checkSiteStatus()
    {
        $website = Company::select('website_status')->find(1);
        if (!$website) {
            return response()->json([
                'error' => 'Company not found'
            ], 404);
        }

        return response()->json([
            'website_status' => $website->website_status
        ], 200);
    }

    public function getWebsiteData()
    {
        $company = Company::find(1);
        return response()->json($company);
    }
}
