<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AdminAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            return $next($request);
        }

        // For API or AJAX requests, return 401
        if ($request->expectsJson()) {
            return response()->json(['message' => 'Unauthorized. Please log in.'], 401);
        }

        // Redirect to login page if 'user_id' is not present
        session()->flash('error', 'Login is required to access the page or functionality.');
        return redirect()->route('login');
    }
}
