<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Courses extends Model
{
    use HasFactory;

    protected $table = 'courses';

    protected $fillable = [
        'category_id',
        'position_order',
        'course_icon',
        'course_name',
        'course_short_title',
        'course_code',
        'course_duration',
        'course_semester',
        'course_url',
        'course_category',
        'short_description',
        'breadcrumb_headline',
        'course_headline',
        'description',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'course_headline_guess_papers',
        'breadcrumb_headline_guess_papers',
        'description_guess_papers',
        'meta_title_guess_papers',
        'meta_keyword_guess_papers',
        'meta_description_guess_papers',
        'course_headline_projects',
        'breadcrumb_headline_projects',
        'description_projects',
        'meta_title_projects',
        'meta_keyword_projects',
        'meta_description_projects',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'category_id' => 'integer',
        'position_order' => 'integer',
        'course_icon' => 'string',
        'course_name' => 'string',
        'course_short_title' => 'string',
        'course_code' => 'string',
        'course_duration' => 'integer',
        'course_semester' => 'integer',
        'course_url' => 'string',
        'course_category' => 'string',
        'short_description' => 'string',
        'course_headline' => 'string',
        'breadcrumb_headline' => 'string',
        'description' => 'string',
        'meta_title' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'course_headline_guess_papers' => 'string',
        'breadcrumb_headline_guess_papers' => 'string',
        'description_guess_papers' => 'string',
        'meta_title_guess_papers' => 'string',
        'meta_keyword_guess_papers' => 'string',
        'meta_description_guess_papers' => 'string',
        'course_headline_projects' => 'string',
        'breadcrumb_headline_projects' => 'string',
        'description_projects' => 'string',
        'meta_title_projects' => 'string',
        'meta_keyword_projects' => 'string',
        'meta_description_projects' => 'string',
        'status' => 'string',
    ];

    public function category()
    {
        return $this->belongsTo(Categories::class, 'category_id', 'id');
    }

    public function subjects()
    {
        return $this->hasMany(Subjects::class);
    }
}
