<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pricing extends Model
{
    use HasFactory;

    protected $table = 'plans';

    protected $fillable = [
        'position_order',
        'plan_name',
        'plan_price',
        'plan_price_base',
        'plan_storage_limit',
        'plan_category',
        'short_description',
        'description',
        'plan_image',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'position_order' => 'integer',
        'plan_name' => 'string',
        'plan_price' => 'decimal:2',
        'plan_price_base' => 'string',
        'plan_storage_limit' => 'integer',
        'plan_category' => 'string',
        'short_description' => 'string',
        'description' => 'string',
        'plan_image' => 'string',
        'status' => 'string',
    ];
}
