<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Template extends Model
{
    use HasFactory;

    protected $table = 'templates';

    protected $fillable = [
        'template_type',
        'short_description',
        'download_info',
        'description',
        'cover_page_info',
        'terms_conditions_text',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'template_type' => 'string',
        'short_description' => 'string',
        'download_info' => 'string',
        'description' => 'string',
        'cover_page_info' => 'string',
        'terms_conditions_text' => 'string',
        'status' => 'string',
    ];
}
