<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoices extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'invoice_number',
        'amount',
        'payment_mode',
        'currency',
        'status',
        'file_path',
    ];

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id');
    }

    public function orders()
    {
        return $this->belongsToMany(Orders::class, 'order_invoices', 'invoice_id', 'order_id');
    }
}
