<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company', function (Blueprint $table) {
            $table->id();
            $table->string('company_icon')->nullable();
            $table->string('company_logo')->nullable();
            $table->string('company_footer_logo')->nullable();
            $table->string('company_name')->nullable();
            $table->string('alert_message')->nullable();
            $table->string('socials_visibility')->nullable();
            $table->string('facebook_url')->nullable();
            $table->string('x_url')->nullable();
            $table->string('linkedin_url')->nullable();
            $table->string('youtube_url')->nullable();
            $table->string('instagram_url')->nullable();
            $table->string('telegram_url')->nullable();
            $table->string('whatsapp_url')->nullable();
            $table->string('footer_content_visibility')->nullable();
            $table->longText('footer_content')->nullable();
            $table->string('phone')->nullable();
            $table->string('whatsapp_phone')->nullable();
            $table->string('alternate_phone')->nullable();
            $table->string('email')->nullable();
            $table->string('alternate_email')->nullable();
            $table->longText('footer_location')->nullable();
            $table->longText('availability')->nullable();
            $table->string('location_visibility')->nullable();
            $table->longText('location')->nullable();
            $table->longText('alternate_location')->nullable();
            $table->string('map_link_visibility')->nullable();
            $table->longText('map_link')->nullable();
            $table->tinyInteger('website_status')->default(0);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company');
    }
};
