<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('category_id')->index();
            $table->unsignedInteger('position_order');
            $table->string('course_icon', 255)->nullable();
            $table->string('course_name');
            $table->string('course_short_title');
            $table->string('course_code');
            $table->integer('course_duration')->nullable();
            $table->integer('course_semester')->nullable();
            $table->string('course_url')->nullable();
            $table->string('course_category', 255)->nullable();
            $table->longText('short_description')->nullable();
            $table->string('course_headline');
            $table->string('breadcrumb_headline')->nullable();
            $table->longText('description')->nullable();
            $table->string('meta_title')->nullable();
            $table->text('meta_keyword')->nullable();
            $table->longText('meta_description')->nullable();
            $table->string('course_headline_guess_papers');
            $table->string('breadcrumb_headline_guess_papers')->nullable();
            $table->longText('description_guess_papers')->nullable();
            $table->string('meta_title_guess_papers')->nullable();
            $table->text('meta_keyword_guess_papers')->nullable();
            $table->longText('meta_description_guess_papers')->nullable();
            $table->string('course_headline_projects');
            $table->string('breadcrumb_headline_projects')->nullable();
            $table->longText('description_projects')->nullable();
            $table->string('meta_title_projects')->nullable();
            $table->text('meta_keyword_projects')->nullable();
            $table->longText('meta_description_projects')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
