<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cart_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained()->cascadeOnDelete();
            $table->string('item_id');
            $table->integer('course_id');
            $table->integer('subject_id');
            $table->integer('assignment_id')->nullable();
            $table->integer('project_id')->nullable();
            $table->integer('guess_paper_id')->nullable();
            $table->integer('type_id')->nullable();
            $table->integer('language_id')->nullable();
            $table->integer('session_id')->nullable();
            $table->integer('quantity');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cart_items');
    }
};
