<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('handwritten_data', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('customer_id')->index();
            $table->text('category_generated_id')->nullable();
            $table->unsignedInteger('course_id')->index();
            $table->text('subject_codes');
            // $table->unsignedInteger('assignment_id')->index();
            $table->unsignedInteger('language_id')->index();
            $table->unsignedInteger('session_id')->index();
            $table->integer('quantity');
            $table->unsignedInteger('price');
            $table->string('assignment_method')->nullable();
            $table->string('file_name')->nullable();
            $table->text('file_path')->nullable();
            $table->longText('comments')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('handwritten_data');
    }
};
