@extends('admin.layouts.main-layout')

@php
    $title = 'View Payments regarding ' . $customer->first_name . ' ' . $customer->last_name;
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">{{ $title }}<span class="float-end"><a href="{{ route('get.all.customers') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i
                                class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span>
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Plan</th>
                                <th>Plan Price <small>(In INR)</small></th>
                                <th>Expiration Date</th>
                                <th>Storage Limit <small>(In GBs)</small></th>
                                <th>Transaction Status</th>
                                <th>Payment Order ID</th>
                                <th>Payment ID</th>
                                <th>Invoice Number</th>
                                <th>Invoices</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            @foreach ($customer_plans as $customer_plan)
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>{{ $customer_plan->plan->plan_name }}</td>
                                    <td>{{ $customer_plan->plan->plan_price . '/' . ucwords($customer_plan->plan->plan_price_base) }}
                                    </td>
                                    <td>{{ date('F d, Y', strtotime($customer_plan->expiry_date)) }}</td>
                                    <td>{{ $customer_plan->plan->plan_storage_limit }}</td>
                                    <td>{{ $customer_plan->transaction->transaction_status == 'success' ? 'Successful' : 'Failed' }}
                                    </td>
                                    <td>{{ $customer_plan->transaction->gateway_order_id }}</td>
                                    <td>{{ $customer_plan->transaction->gateway_payment_id }}</td>
                                    <td>{{ $customer_plan->invoice->invoice_number }}</td>
                                    <td>
                                        <a href="{{ route('invoice.show', $customer_plan->invoice->encrypted_id) }}"
                                            target="_blank" class="btn btn-primary mt-2">
                                            View Invoice
                                        </a>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>

@endsection

@section('admin-custom-js')
    <script>
        $("#table").DataTable();
    </script>
@endsection
