@extends('admin.admin-layouts.main-layout')

<?php if(!empty($highlight)) {

    $title = "Edit Highlight";

} else {

    $title = "Add Highlight";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($highlight) ? route('edit.highlight', $highlight->encrypted_id) : route('add.highlight') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_highlights') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Hightlight Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($highlight) ? $highlight->position_order : '' }}" placeholder="Enter Position" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="highlight_headline" class="col-sm-3 col-form-label">Hightlight Headline</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="highlight_headline" name="highlight_headline" value="{{ !empty($highlight) ? $highlight->highlight_headline : '' }}" placeholder="Enter Name" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="description" class="col-sm-3 col-form-label">Description</label>

                                <div class="col-sm-9">

                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($highlight) ? htmlspecialchars_decode($highlight->description) : '' }}</textarea>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-sm-12">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="highlight_image" class="col-sm-3 col-form-label">Highlight Image</label>

                                    <div class="col-sm-9">

                                        @if(!empty($highlight))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $highlight->highlight_image) }}" alt="Highlight_Image" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="highlight_image" name="highlight_image" />

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($highlight) ? 'Update Highlight' : 'Add Highlight' }}" class="btn btn-primary" />

                        <a href="{{ route('manage_highlights') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



@endsection

