@extends('admin.admin-layouts.main-layout')
<?php if(!empty($med_section)) {
    $title = "Edit Med-India Section";
} else {
    $title = "Add Med-India Section";
}

?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($med_section) ? route('edit.medsection', $med_section->encrypted_id) : route('add.medsection') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_med_sections') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row mb-3">
                                <label for="position_order" class="col-sm-3 col-form-label">Med-Section Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($med_section) ? $med_section->position_order : '' }}" placeholder="Enter Position" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="section_title" class="col-sm-3 col-form-label">Med-Section Title</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="section_title" name="section_title" value="{{ !empty($med_section) ? $med_section->section_title : '' }}" placeholder="Enter Title" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="section_headline" class="col-sm-3 col-form-label">Med-Section Headline</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="section_headline" name="section_headline" value="{{ !empty($med_section) ? $med_section->section_headline : '' }}" placeholder="Enter Headline" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="description" class="col-sm-3 col-form-label">Description</label>
                                <div class="col-sm-9">
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($med_section) ? htmlspecialchars_decode($med_section->description) : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($med_section) ? 'Update Med-Section' : 'Add Med-Section' }}" class="btn btn-primary" />
                        <a href="{{ route('manage_med_sections') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

@endsection
