@extends('admin.admin-layouts.main-layout')

<?php if(!empty($treatment)) {

    $title = "Edit Treatment & Sub-Treatment Management";

} else {

    $title = "Add Treatment";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($treatment) ? route('edit.treatment', $treatment->encrypted_id) : route('add.treatment') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_treatments') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @elseif (session('success'))

                    <div class="alert alert-success alert-dismissible" role="alert">

                        {{ session('success') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Treatment Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($treatment) ? $treatment->position_order : '' }}" placeholder="Enter Position" />

                                    @error('position_order')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment_title" class="col-sm-3 col-form-label">Treatment Title</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_title" name="treatment_title" value="{{ !empty($treatment) ? $treatment->treatment_title : '' }}" placeholder="Enter Headline" onblur="getUrl(this.id)" />

                                    @error('treatment_title')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment_headline" class="col-sm-3 col-form-label">Treatment Headline</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_headline" name="treatment_headline" value="{{ !empty($treatment) ? $treatment->treatment_headline : '' }}" placeholder="Enter Headline" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment_link" class="col-sm-3 col-form-label">Treatment URL</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_link" name="treatment_link" value="{{ !empty($treatment) ? $treatment->treatment_link : '' }}" placeholder="Enter Headline" />

                                    @error('treatment_link')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="sub_description" class="col-sm-3 col-form-label">Sub-Description</label>

                                <div class="col-sm-9">

                                    <textarea name="sub_description" id="sub_description" cols="30" rows="5" class="form-control" placeholder="Enter Sub-Description" >{{ !empty($treatment) ? htmlspecialchars_decode($treatment->sub_description) : '' }}</textarea>

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="description" class="col-sm-3 col-form-label">Description</label>

                                <div class="col-sm-9">

                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($treatment) ? htmlspecialchars_decode($treatment->description) : '' }}</textarea>

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="meta_title" class="col-sm-3 col-form-label">Meta Title</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ !empty($treatment) ? $treatment->meta_title : '' }}" placeholder="Enter Meta Title" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="meta_keyword" class="col-sm-3 col-form-label">Meta Keyword</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="{{ !empty($treatment) ? $treatment->meta_keyword : '' }}" placeholder="Enter Meta Keyword" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="meta_description" class="col-sm-3 col-form-label">Meta Description</label>

                                <div class="col-sm-9">

                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Meta Description" >{{ !empty($treatment) ? htmlspecialchars_decode($treatment->meta_description) : '' }}</textarea>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-sm-6">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="treatment_icon" class="col-sm-3 col-form-label">Treatment Icon</label>

                                    <div class="col-sm-9">

                                        @if(!empty($treatment))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $treatment->treatment_icon) }}" alt="Treatment_Icon" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="treatment_icon" name="treatment_icon" accept=".jpg, .jpeg, .png, .webp" />

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-sm-6">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="treatment_image" class="col-sm-3 col-form-label">Treatment Image</label>

                                    <div class="col-sm-9">

                                        @if(!empty($treatment))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $treatment->treatment_image) }}" alt="Treatment_Image" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="treatment_image" name="treatment_image" accept=".jpg, .jpeg, .png, .webp" />

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($treatment) ? "Update Treatment" : "Add Treatment" }}" class="btn btn-primary" />

                        <a href="{{ route('manage_treatments') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



<script>



    function getUrl(id) {

        let treatment_title = $.trim($("#"+id).val());

        let treatment_link = treatment_title.replace(/\s+/g, '-').toLowerCase();

        $("#treatment_link").val(treatment_link);

    }



</script>



@endsection

