@extends('admin.admin-layouts.main-layout')
<?php if(!empty($section)) {
    $title = "Edit Section";
} else {
    $title = "Add Section";
}

?>

@section('title', $title)

@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($section) ? route('edit.whyIndiaSection', $section->encrypted_id) : route('add.whyIndiaSection') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_why_india_sections') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Section Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($section) ? $section->position_order : '' }}" placeholder="Enter Position" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="section_headline" class="col-sm-3 col-form-label">Section Headline</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="section_headline" name="section_headline" value="{{ !empty($section) ? $section->section_headline : '' }}" placeholder="Enter Headline" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="description" class="col-sm-3 col-form-label">Description</label>

                                <div class="col-sm-9">

                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($section) ? htmlspecialchars_decode($section->description) : '' }}</textarea>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-sm-12">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="section_image" class="col-sm-3 col-form-label">Section Image</label>

                                    <div class="col-sm-9">

                                        @if(!empty($section))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $section->section_image) }}" alt="Section_Image" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="section_image" name="section_image" />

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($section) ? 'Update Section' : 'Add Section' }}" class="btn btn-primary" />

                        <a href="{{ route('manage_why_india_sections') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



@endsection

