@extends('admin.layouts.main-layout')
<?php if (!empty($faq->encrypted_id)) {
    $title = 'Edit FAQ';
} else {
    $title = 'Add FAQ';
}
?>
@section('title', $title)
@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form action="{{ !empty($faq->encrypted_id) ? route('edit.faq', $faq->encrypted_id) : route('add.faq') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.faqs') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        <label for="question" class="col-form-label">Question</label>
                                        <input type="text" class="form-control" id="question" name="question"
                                            value="{{ !empty($faq->encrypted_id) ? $faq->question : '' }}"
                                            placeholder="Enter Question" />
                                        @error('question')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-12">
                                        <label for="answer" class="col-form-label">Answer</label>
                                        <textarea name="answer" id="answer" cols="30" rows="5" class="form-control" placeholder="Enter Answer">{{ !empty($faq->encrypted_id) ? htmlspecialchars_decode($faq->answer) : '' }}</textarea>
                                        @error('answer')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit" value="{{ !empty($faq->encrypted_id) ? 'Update FAQ' : 'Add FAQ' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.faqs') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

@endsection
