@extends('admin.layouts.main-layout')
<?php if(!empty($form->encrypted_id)) {
    $title = "Edit Form";
} else {
    $title = "Add Form";
}

?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($form->encrypted_id) ? route('edit.form', $form->encrypted_id) : route('add.form') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_forms') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @elseif (session('success'))
                    <div class="alert alert-success alert-dismissible" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            {{-- <div class="mb-3 row">
                                <label for="position_order" class="col-sm-3 col-form-label">Form Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ $blog_content->position_order }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div> --}}
                            <div class="mb-3 row">
                                <label for="form_template" class="col-sm-3 col-form-label">Form Template</label>
                                <div class="col-sm-9">
                                    <select name="form_template" id="form_template" class="form-select">
                                        @if(!empty($form->form_template))
                                        <option value="client-engagement" {{ $form->form_template == 'client-engagement' ? 'selected' : '' }}>Client Engagement</option>
                                        <option value="entity-engagement" {{ $form->form_template == 'entity-engagement' ? 'selected' : '' }}>Entity Engagement</option>
                                        <option value="service-request" {{ $form->form_template == 'service-request' ? 'selected' : '' }}>Service Request</option>
                                        @else
                                        <option value="client-engagement">Client Engagement</option>
                                        <option value="entity-engagement">Entity Engagement</option>
                                        <option value="service-request">Service Request</option>
                                        @endif
                                    </select>
                                    @error('form_template')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="form_name" class="col-sm-3 col-form-label">Form Name</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="form_name" name="form_name" value="{{ !empty($form->encrypted_id) ? $form->form_name : old('form_name') }}" placeholder="Enter Name" onblur="getUrl(this.id)" />
                                    @error('form_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="form_url" class="col-sm-3 col-form-label">Form URL</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="form_url" name="form_url" value="{{ !empty($form->encrypted_id) ? $form->form_url : old('form_url') }}" placeholder="Enter URL" />
                                    @error('form_url')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="description" class="col-sm-3 col-form-label">Description</label>
                                <div class="col-sm-9">
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($form->encrypted_id) ? htmlspecialchars_decode($form->description) : old('description') }}</textarea>
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="meta_title" class="col-sm-3 col-form-label">Meta Title</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ !empty($form->encrypted_id) ? $form->meta_title : old('meta_title') }}" placeholder="Enter Title" />
                                    @error('meta_title')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="meta_keyword" class="col-sm-3 col-form-label">Meta Keyword</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="{{ !empty($form->encrypted_id) ? $form->meta_keyword : old('meta_keyword') }}" placeholder="Enter Keywords" />
                                    @error('meta_keyword')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="meta_description" class="col-sm-3 col-form-label">Meta Description</label>
                                <div class="col-sm-9">
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($form->encrypted_id) ? htmlspecialchars_decode($form->meta_description) : old('meta_description') }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body row">
                                    <label for="form_image" class="col-sm-3 col-form-label">Form Image</label>
                                    <div class="col-sm-9">
                                        @if(!empty($form->encrypted_id) && !empty($form->form_image))
                                        <div class="my-3">
                                            <div style="display: inline-block; position: relative; margin: 5px;">
                                                <img src="{{ asset($form->form_image) }}" alt="Form_Image" class="rounded" height="60px" width="60px" style="object-fit: cover;">
                                                <button style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        </div>
                                        @endif
                                        <input class="form-control" type="file" id="form_image" name="form_image" accept="image/*" />
                                        @error('form_image')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h5 class="card-header mb-3">Section Management</h5>
                    <div id="all-sections"></div>
                    <span class="float-end"><button type="button" id="add-row" class="btn rounded-pill btn-icon btn-primary float-end" style="font-size: 1.7em;">+</button></span>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($form->encrypted_id) ? 'Update Form' : 'Add Form' }}" class="btn btn-primary" />
                        <a href="{{ route('manage_forms') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

<script>

    function getUrl(field_id) {
        let errors = 0;
        let form_name = $.trim($("#" + field_id).val());
        let id = "{{ !empty($form->encrypted_id) ? $form->encrypted_id : '' }}";

        // Replace '/' and spaces with '-'
        let form_url = form_name.replace(/[\/\s]+/g, '-').toLowerCase();

        if(form_name == "" || form_name == undefined || form_name == null) {
            errors += 1;
        }
        if(form_url == "" || form_url == undefined || form_url == null) {
            errors += 1;
        }

        if(errors > 0) {
            $("#form_url").val("");
            return false;
        }
        else {
            // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
            form_url = form_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');

            // Use Blade to generate the base route and append parameters dynamically
            let url = "{{ route('check.form.link', ['form_url' => '__LINK__', 'id' => '__ID__']) }}"
                .replace('__LINK__', form_url)
                .replace('__ID__', id);

            // Send GET request with parameters in the URL
            fetch(url)
                .then(response => response.text()) // Expecting plain text response
                .then(data => {
                    document.getElementById("form_url").value = data; // Update input field with returned link
                    // $("#form_url").val(data);
                })
                .catch(error => console.error("Error:", error));
        }
    }

</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let rowCount = 1;

        // Function to add a new row
        function addRow(item = {}) {

            // Create the main card div
            const card = document.createElement('div');
            card.className = 'card mb-4';
            card.id = `row-${rowCount}`;
            
            // Create the card body
            const cardBody = document.createElement('div');
            cardBody.className = 'card-body';
            
            // Hidden input for ID
            const idInput = document.createElement('input');
            idInput.type = 'hidden';
            idInput.name = 'sections[]';
            idInput.value = item.section_id || '';
            cardBody.appendChild(idInput);
            
            // Create the first row (Section Title)
            const row1 = document.createElement('div');
            row1.className = 'row mb-3';
            
            const col1 = document.createElement('div');
            col1.className = 'col-sm-6';
            
            // Label for Section Title
            const label1 = document.createElement('label');
            label1.htmlFor = `sectionTitles-${rowCount}`;
            label1.className = 'col-form-label';
            label1.textContent = 'Section Title';
            
            const input1 = document.createElement('input');
            input1.type = 'text';
            input1.className = 'form-control';
            input1.id = `sectionTitles-${rowCount}`;
            input1.name = 'section_titles[]';
            input1.placeholder = 'Enter Title';
            input1.value = item.section_title || '';
            
            const col11 = document.createElement('div');
            col11.className = 'col-sm-6';
            
            // Label for Section Headline
            const label11 = document.createElement('label');
            label11.htmlFor = `sectionHeadlines-${rowCount}`;
            label11.className = 'col-form-label';
            label11.textContent = 'Section Headline';
            
            const input11 = document.createElement('input');
            input11.type = 'text';
            input11.className = 'form-control';
            input11.id = `sectionHeadlines-${rowCount}`;
            input11.name = 'section_headlines[]';
            input11.placeholder = 'Enter Headline';
            input11.value = item.section_headline || '';
            input11.required = true;
            
            // Prevent removal of the required attribute
            Object.defineProperty(input11, 'required', {
                configurable: false,
                writable: false,
                value: true,
            });
            
            // Append input to column and label + column to row
            col1.appendChild(label1);
            col1.appendChild(input1);
            col11.appendChild(label11);
            col11.appendChild(input11);
            row1.appendChild(col1);
            row1.appendChild(col11);
            
            // Create the forth row (Description)
            const row22 = document.createElement('div');
            row22.className = 'row mb-3';
            
            // Textarea for Description
            const col22 = document.createElement('div');
            col22.className = 'col-sm-12';
            
            // Label for Description
            const label22 = document.createElement('label');
            label22.htmlFor = `sectionDescriptions-${rowCount}`;
            label22.className = 'col-form-label';
            label22.textContent = 'Description';
            
            const textarea22 = document.createElement('textarea');
            textarea22.id = `sectionDescriptions-${rowCount}`;
            textarea22.name = 'section_descriptions[]';
            textarea22.cols = 30;
            textarea22.rows = 5;
            textarea22.className = 'text-area form-control';
            textarea22.placeholder = 'Enter Description';
            textarea22.textContent = item.section_description || '';

            // Append textarea to column and label + column to row
            row22.appendChild(label22);
            col22.appendChild(textarea22);
            row22.appendChild(col22);


            // Add Button Div
            const buttonsDiv = document.createElement('div');
            buttonsDiv.classList.add('float-end');

            // Remove Button
            const removeButton = document.createElement('button');
            removeButton.type = 'button';
            removeButton.classList.add('btn', 'btn-danger', 'btn-icon', 'rounded-pill');
            removeButton.innerHTML = `<i class="bx bx-trash"></i>`;
            removeButton.onclick = function () {
                if(item && item.section_id) {
                    $.ajax({
                        url: "{{ route('delete.form.section') }}",
                        method: "POST",
                        data: {'section': item.section_id, '_token': '{{ csrf_token() }}'},
                        success: function(res) {
                            card.remove();
                        }
                    });
                }
                else {
                    card.remove();
                }
            };
            buttonsDiv.appendChild(removeButton);
            
            // Append rows to card body
            cardBody.appendChild(row1);
            cardBody.appendChild(row22);
            cardBody.appendChild(buttonsDiv);
            
            // Append card body to card
            card.appendChild(cardBody);

            // Append the new row to the form
            document.getElementById('all-sections').appendChild(card);
            
            // Initialize TinyMCE for the newly created textarea
            tinymce.init({
                selector: `.text-area`, // Target the newly created textarea by its ID
                valid_elements: '*[*]',
                extended_valid_elements: 'span[class],i[class]',
                plugins: 'a11ychecker advcode advlist advtable anchor autocorrect autolink autoresize autosave casechange charmap checklist code codesample directionality editimage emoticons export footnotes formatpainter fullscreen help image importcss inlinecss insertdatetime link linkchecker lists media mediaembed mentions mergetags nonbreaking pagebreak pageembed permanentpen powerpaste preview quickbars save searchreplace table tableofcontents template tinycomments tinydrive tinymcespellchecker typography visualblocks visualchars wordcount',
                toolbar: 'undo redo | blocks| bold italic | bullist numlist checklist | code | table | alignleft aligncenter alignright alignjustify | outdent indent | wordcount | a11ycheck advtablerownumbering typopgraphy anchor restoredraft casechange charmap checklist code codesample addcomment showcomments ltr rtl editimage fliph flipv imageoptions rotateleft rotateright emoticons export footnotes footnotesupdate formatpainter fullscreen help image insertdatetime link openlink unlink bullist numlist media mergetags mergetags_list nonbreaking pagebreak pageembed permanentpen preview quickimage quicklink quicktable cancel save searchreplace spellcheckdialog spellchecker',
                resize: 'both'
            });
            
            rowCount++;
        }

        @if(!empty($form->encrypted_id))

        // Fetch data from the server (get_sub_section_data.php) and add rows
        fetch("{{ route('get.form.sections', $form->encrypted_id) }}")
            .then(response => response.json())
            .then(data => {
                data.forEach(item => {
                    addRow(item);
                });
            });
            
        @endif

        // Event listener to add a new blank row when "Add Row" button is clicked
        document.getElementById('add-row').addEventListener('click', () => {
            addRow();
        });
    });
</script>

@endsection
