@extends('admin.layouts.main-layout')
<?php if (!empty($guess_paper->encrypted_id)) {
    $title = 'Edit Guess Paper';
} else {
    $title = 'Add Guess Paper';
}
?>
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($guess_paper->encrypted_id) ? route('edit.guess.paper', ['guess_paper' => $guess_paper->encrypted_id]) : route('add.guess.paper') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.guess.papers') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="subject_id" class="form-label">Subject</label>
                                        <select name="subject_id" id="subject_id" class="form-select">
                                            <option value="">-- Select Subject --</option>
                                            @foreach ($all_subjects as $subject)
                                                @if (!empty($guess_paper->encrypted_id))
                                                    <option value="{{ $subject->encrypted_id }}"
                                                        {{ $guess_paper->subject_id == $subject->id ? 'selected' : '' }}>
                                                        {{ $subject->subject_code . ' (' . $subject->subject_name . ')' }}
                                                    </option>
                                                @else
                                                    <option value="{{ $subject->encrypted_id }}">
                                                        {{ $subject->subject_code . ' (' . $subject->subject_name . ')' }}
                                                    </option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @error('subject_id')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="type_ids" class="form-label">Type(s)</label>
                                        <select name="type_ids[]" id="type_ids" class="form-select" multiple>
                                            @php
                                                $selectedTypes = !empty($guess_paper->encrypted_id)
                                                    ? $guess_paper->types->pluck('id')->toArray()
                                                    : [];
                                            @endphp
                                            @foreach ($all_guess_paper_types as $guess_paper_type)
                                                <option value="{{ $guess_paper_type->encrypted_id }}"
                                                    {{ in_array($guess_paper_type->id, $selectedTypes) ? 'selected' : '' }}>
                                                    {{ $guess_paper_type->type_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('type_ids')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="language_ids" class="form-label">Medium</label>
                                        @php
                                            $selectedLanguages = !empty($guess_paper->encrypted_id)
                                                ? $guess_paper->languages->pluck('id')->toArray()
                                                : [];
                                        @endphp
                                        <select name="language_ids[]" id="language_ids" class="form-select" multiple>
                                            @foreach ($all_guess_paper_languages as $guess_paper_language)
                                                <option value="{{ $guess_paper_language->encrypted_id }}"
                                                    {{ in_array($guess_paper_language->id, $selectedLanguages) ? 'selected' : '' }}>
                                                    {{ $guess_paper_language->language_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('language_ids')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="session_ids" class="form-label">Session(s)</label>
                                        @php
                                            $selectedSessions = !empty($guess_paper->encrypted_id)
                                                ? $guess_paper->sessions->pluck('id')->toArray()
                                                : [];
                                        @endphp
                                        <select name="session_ids[]" id="session_ids" class="form-select" multiple>
                                            @foreach ($all_guess_paper_sessions as $guess_paper_session)
                                                <option value="{{ $guess_paper_session->encrypted_id }}"
                                                    {{ in_array($guess_paper_session->id, $selectedSessions) ? 'selected' : '' }}>
                                                    {{ $guess_paper_session->session_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('session_ids')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="coupon_ids" class="form-label">Coupon(s)</label>
                                        @php
                                            $selectedCoupons = !empty($guess_paper->encrypted_id)
                                                ? $guess_paper->coupons->pluck('id')->toArray()
                                                : [];
                                        @endphp
                                        <select name="coupon_ids[]" id="coupon_ids" class="form-select" multiple>
                                            @foreach ($all_guess_paper_coupons as $guess_paper_coupon)
                                                <option value="{{ $guess_paper_coupon->encrypted_id }}"
                                                    {{ in_array($guess_paper_coupon->id, $selectedCoupons) ? 'selected' : '' }}>
                                                    <strong>{{ $guess_paper_coupon->coupon }}
                                                        <small>{{ $guess_paper_coupon->coupon_name }}</small>
                                                    </strong>
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('coupon_ids')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="guess_paper_code" class="col-form-label">Guess Paper Code</label>
                                        <input type="text" class="form-control" id="guess_paper_code"
                                            name="guess_paper_code"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->guess_paper_code : old('guess_paper_code') }}"
                                            oninput="this.value = this.value.replace(/[^A-Za-z0-9-]/g, '')"
                                            placeholder="Enter Code" onblur="getUrl(this.id)" />
                                        @error('guess_paper_code')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="guess_paper_subject_name" class="col-form-label">guess_paper Subject
                                            Name</label>
                                        <input type="text" class="form-control" id="guess_paper_subject_name"
                                            name="guess_paper_subject_name"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->guess_paper_subject_name : old('guess_paper_subject_name') }}"
                                            placeholder="Enter Name" />
                                        @error('guess_paper_subject_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="guess_paper_url" class="col-form-label">Guess Paper URL</label>
                                        <input type="text" class="form-control" id="guess_paper_url"
                                            name="guess_paper_url"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->guess_paper_url : old('guess_paper_url') }}"
                                            placeholder="Enter URL" />
                                        @error('guess_paper_url')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="guess_paper_title" class="col-form-label">Guess Paper Title</label>
                                        <input type="text" class="form-control" id="guess_paper_title"
                                            name="guess_paper_title"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->guess_paper_title : old('guess_paper_title') }}"
                                            placeholder="Enter Title" />
                                        @error('guess_paper_title')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="breadcrumb_headline" class="col-form-label">Breadcrumb
                                            Headline</label>
                                        <input type="text" class="form-control" id="breadcrumb_headline"
                                            name="breadcrumb_headline"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->breadcrumb_headline : old('breadcrumb_headline') }}"
                                            placeholder="Enter Headline" />
                                        @error('breadcrumb_headline')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="guess_paper_quantity" class="col-form-label">Guess Paper
                                            Quantity</label>
                                        <input type="text" class="form-control" id="guess_paper_quantity"
                                            name="guess_paper_quantity"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->guess_paper_quantity : old('guess_paper_quantity') }}"
                                            placeholder="Enter Quantity"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '');" />
                                        @error('guess_paper_quantity')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="maximum_retail_price" class="col-form-label">MRP</label>
                                        <input type="text" class="form-control" id="maximum_retail_price"
                                            name="maximum_retail_price"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->maximum_retail_price : old('maximum_retail_price') }}"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter MRP" />
                                        @error('maximum_retail_price')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="selling_price" class="col-form-label">Selling Price</label>
                                        <input type="text" class="form-control" id="selling_price"
                                            name="selling_price"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->selling_price : old('selling_price') }}"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter Selling Price" />
                                        @error('selling_price')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="discount" class="col-form-label">Discount (In %)</label>
                                        <input type="text" class="form-control" id="discount" name="discount"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->discount : old('discount') }}"
                                            placeholder="Enter Discount"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '');" />
                                        @error('discount')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="additional_discount" class="col-form-label">Extra Discount (In
                                            %)</label>
                                        <input type="text" class="form-control" id="additional_discount"
                                            name="additional_discount"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->additional_discount : old('additional_discount') }}"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '');"
                                            placeholder="Enter Extra Discount" />
                                        @error('additional_discount')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="discount_offer_expiry" class="col-form-label">Discount Expiry</label>
                                        <input type="datetime-local" class="form-control" id="discount_offer_expiry"
                                            name="discount_offer_expiry"
                                            value="{{ !empty($guess_paper->encrypted_id) && $guess_paper->discount_offer_expiry ? \Carbon\Carbon::parse($guess_paper->discount_offer_expiry)->format('Y-m-d\TH:i') : old('discount_offer_expiry') }}"
                                            placeholder="Enter Discount Expiry" />
                                        @error('discount_offer_expiry')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="guess_paper_expiry" class="col-form-label">Guess Paper Expiry</label>
                                        <input type="datetime-local" class="form-control" id="guess_paper_expiry"
                                            name="guess_paper_expiry"
                                            value="{{ !empty($guess_paper->encrypted_id) && $guess_paper->guess_paper_expiry ? \Carbon\Carbon::parse($guess_paper->guess_paper_expiry)->format('Y-m-d\TH:i') : old('guess_paper_expiry') }}"
                                            placeholder="Enter guess_paper Expiry" />
                                        @error('guess_paper_expiry')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    @if (!empty($guess_paper->encrypted_id))
                                        <div class="col-12">
                                            <label for="short_description" class="col-form-label">Short
                                                Description</label>
                                            <textarea id="short_description" name="short_description" class="form-control"
                                                placeholder="Enter Short Description">{{ !empty($guess_paper->encrypted_id) ? htmlspecialchars_decode($guess_paper->short_description) : '' }}</textarea>
                                        </div>
                                        <div class="col-12">
                                            <label for="download_info" class="col-form-label">Download Information</label>
                                            <textarea id="download_info" name="download_info" class="form-control" placeholder="Enter Download Information">{{ !empty($guess_paper->encrypted_id) ? htmlspecialchars_decode($guess_paper->download_info) : '' }}</textarea>
                                        </div>
                                        <div class="col-12">
                                            <label for="description" class="col-form-label">Description</label>
                                            <textarea id="description" name="description" class="form-control" placeholder="Enter Description">{{ !empty($guess_paper->encrypted_id) ? htmlspecialchars_decode($guess_paper->description) : '' }}</textarea>
                                        </div>
                                        <div class="col-12">
                                            <label for="cover_page_info" class="col-form-label">Cover Page
                                                Information</label>
                                            <textarea id="cover_page_info" name="cover_page_info" class="form-control" placeholder="Enter Cover Page Info">{{ !empty($guess_paper->encrypted_id) ? htmlspecialchars_decode($guess_paper->cover_page_info) : '' }}</textarea>
                                        </div>
                                        {{-- <div class="col-12">
                                            <label for="terms_conditions_text" class="col-form-label">Terms &
                                                Conditions</label>
                                            <textarea id="terms_conditions_text" name="terms_conditions_text" class="form-control"
                                                placeholder="Enter Terms & Conditions">{{ !empty($guess_paper->encrypted_id) ? htmlspecialchars_decode($guess_paper->terms_conditions_text) : '' }}</textarea>
                                        </div> --}}
                                        {{-- <div class="col-12">
                                            <label for="terms_conditions_text" class="col-form-label">Terms &
                                                Conditions</label>
                                            <textarea id="terms_conditions_text" name="terms_conditions_text" class="form-control"
                                                placeholder="Enter Terms & Conditions">{{ !empty($guess_paper->encrypted_id) ? htmlspecialchars_decode($guess_paper->terms_conditions_text) : '' }}</textarea>
                                        </div> --}}
                                    @endif
                                    <div class="col-6">
                                        <label for="meta_title" class="col-form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->meta_title : '' }}"
                                            placeholder="Enter Meta Title" />
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                        <input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
                                            value="{{ !empty($guess_paper->encrypted_id) ? $guess_paper->meta_keyword : '' }}"
                                            placeholder="Enter Meta Keyword" />
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="col-form-label">Meta Description</label>
                                        <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Meta Description">{{ !empty($guess_paper->encrypted_id) ? htmlspecialchars_decode($guess_paper->meta_description) : '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="guess_paper_image" class="col-form-label">Guess Paper Image</label>
                                        @if (!empty($guess_paper->encrypted_id) && !empty($guess_paper->guess_paper_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($guess_paper->guess_paper_image) }}"
                                                    alt="guess_paper_image" class="rounded" height="60px"
                                                    width="60px" style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="guess_paper_image"
                                            name="guess_paper_image" accept="image/*" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="question_paper_image" class="col-form-label">Question Paper
                                            Image</label>
                                        @if (!empty($guess_paper->encrypted_id) && !empty($guess_paper->question_paper_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($guess_paper->question_paper_image) }}"
                                                    alt="question_paper_image" class="rounded" height="60px"
                                                    width="60px" style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="question_paper_image"
                                            name="question_paper_image" accept="image/*" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="{{ !empty($guess_paper->encrypted_id) ? 'Update Guess Paper' : 'Add Guess Paper' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.guess.papers') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof $ === 'undefined' || !$.fn.select2) {
                console.error('Select2 or jQuery not loaded');
                return;
            }

            $('#subject_id').select2({
                placeholder: "Search subject...",
                allowClear: true,
                width: '100%'
            });
        });

        new MultiSelectTag('type_ids');
        new MultiSelectTag('language_ids');
        new MultiSelectTag('session_ids');
        new MultiSelectTag('coupon_ids');
    </script>

    <script>
        function getUrl(field_id) {
            let errors = 0;
            let code = $.trim($("#" + field_id).val());
            let id = "{{ !empty($guess_paper->encrypted_id) ? $guess_paper->encrypted_id : '' }}";

            // Replace '/' and spaces with '-'
            let guess_paper_url = code.replace(/[\/\s]+/g, '-').toLowerCase();

            if (code == "" || code == undefined || code == null) {
                errors += 1;
            }
            if (guess_paper_url == "" || guess_paper_url == undefined || guess_paper_url == null) {
                errors += 1;
            }

            if (errors > 0) {
                $("#guess_paper_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                guess_paper_url = guess_paper_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');

                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.guess.paper.link', ['guess_paper_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', guess_paper_url)
                    .replace('__ID__', id);

                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("guess_paper_url").value =
                            data; // Update input field with returned link
                        // $("#guess_paper_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script>

@endsection
