@extends('admin.layouts.layout')
@section('title', 'Login')

@section('content')

    <!-- Content -->

    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner">
                <!-- Register -->
                @if ($errors->has('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ $errors->first('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center">
                            <a class="app-brand-link gap-2">
                                <span class="app-brand-logo demo">
                                    <img src="{{ asset($websiteData->company_footer_logo) }}" alt="Website_Logo"
                                        width="120px" height="90px">
                                </span>
                            </a>
                        </div>
                        <!-- /Logo -->
                        <h4 class="mb-2">Welcome to {{ $websiteData->company_name }} Admin Panel! 👋</h4>
                        <p class="mb-4">Please sign-in to your account.</p>

                        <form onsubmit="return checkInputs();" id="login_form" class="mb-3" action="{{ route('login') }}"
                            method="POST">
                            @csrf
                            <div class="mb-3">
                                <label for="mail" class="form-label">E-Mail</label>
                                <input type="email" class="form-control" id="mail" name="mail"
                                    placeholder="Enter your E-Mail" autofocus />
                                <div id="mail_error" class="text-danger"></div>
                                @error('mail')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3 form-password-toggle">
                                <div class="d-flex justify-content-between">
                                    <label class="form-label" for="pwd">Password</label>
                                    {{-- <a href="auth-forgot-password-basic.html">
                                        <small>Forgot Password?</small>
                                    </a> --}}
                                </div>
                                <div class="input-group input-group-merge">
                                    <input type="password" id="pwd" class="form-control" name="pwd"
                                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                        aria-describedby="password" />
                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                </div>
                                <div id="pwd_error" class="text-danger"></div>
                                @error('pwd')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            {{-- <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="remember-me" />
                                    <label class="form-check-label" for="remember-me"> Remember Me </label>
                                </div>
                            </div> --}}
                            <div class="mb-3">
                                <button
                                    class="btn btn-primary d-grid w-100 d-flex justify-content-center align-items-center gap-2"
                                    id="loginBtn" type="submit">
                                    <span id="btnText">Sign-In</span>
                                    <span id="btnLoader" class="spinner-border spinner-border-sm d-none" role="status"
                                        aria-hidden="true"></span>
                                </button>

                            </div>
                        </form>

                        {{-- <p class="text-center">
                            <span>New on our platform?</span>
                            <a href="">
                                <span>Create an account</span>
                            </a>
                        </p> --}}
                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>

    <!-- / Content -->

@endsection

@section('admin-custom-js')
    <!-- Core JS -->
    <script>
        function checkInputs() {
            let errors = 0;
            const regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            let mail = $("#mail").val();
            let pwd = $("#pwd").val();

            if (mail == "" || mail == undefined || mail == null) {
                $("#mail_error").html("E-Mail is required!");
                errors += 1;
            } else {
                $("#mail_error").html("");
            }
            if (mail != "") {
                if (!regex.test(mail)) {
                    $("#mail_error").html("Invalid E-Mail");
                    errors += 1;
                } else {
                    $("#mail_error").html("");
                }
            }
            if (pwd == "" || pwd == undefined || pwd == null) {
                $("#pwd_error").html("Password is required!");
                errors += 1;
            } else {
                $("#pwd_error").html("");
            }

            if (errors > 0) {
                return false;
            } else {
                document.getElementById("btnText").textContent = "Please Wait...";
                document.getElementById("btnLoader").classList.remove("d-none");
                document.getElementById("loginBtn").disabled = true;
            }
        }
    </script>

@endsection
