@extends('admin.layouts.main-layout')

@section('title', 'Manage Customers')

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">Manage Customers
                    {{-- @if (session()->get('role') == 'superadmin')
                <a href="{{ route('add.page') }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                @endif
                <a href="{{ route('get.pages.page') }}" class="btn btn-primary float-end me-2">Pages Sequence</a> --}}
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Customer Name</th>
                                <th>Customer E-Mail</th>
                                <th>Customer Active Plan</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            @foreach ($customersData as $customers)
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        <strong>{{ $customers->first_name . ' ' . $customers->last_name }}</strong>
                                    </td>
                                    <td>{{ $customers->email }}</td>
                                    <td>{{ $customers->active_plan }}</td>
                                    <td>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input status_button"
                                                onclick="change_status('<?= $model ?>', <?= $sno ?>, '<?= $customers->encrypted_id ?>');"
                                                type="checkbox" id="status<?= $sno ?>"
                                                <?= $customers->status == 'active' ? 'checked' : '' ?> />
                                        </div>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item"
                                                    href="{{ route('view.customer', $customers->encrypted_id) }}">
                                                    <i class="bx bx-show me-1"></i> View
                                                </a>
                                                <a class="dropdown-item"
                                                    href="{{ route('view.customer.all.payments', $customers->encrypted_id) }}">
                                                    <i class="bx bx-credit-card me-1"></i> View All Payments
                                                    {{-- <i class="bx bx-edit-alt me-1"></i> Edit --}}
                                                </a>
                                                <a class="dropdown-item"
                                                    href="{{ route('view.customer.data', $customers->encrypted_id) }}">
                                                    <i class="bx bx-show me-1"></i> View Data
                                                </a>
                                                @if (session()->get('role') == 'superadmin')
                                                    <button class="dropdown-item"
                                                        onclick="delete_item('<?= $model ?>', '<?= $customers->encrypted_id ?>');">
                                                        <i class="bx bx-trash me-1"></i> Delete
                                                    </button>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>

@endsection

@section('admin-custom-js')
    <script>
        $("#table").DataTable();
    </script>
@endsection
