@extends('admin.layouts.main-layout')

@php
    if (isset($customer)) {
        $title = 'Manage Modules Data regarding ' . $customer->first_name . ' ' . $customer->last_name;
    } else {
        $title = 'Manage Modules Data';
    }
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">{{ $title }}
                    @if (isset($customer))
                        <span class="float-end">
                            <a href="{{ route('get.all.customers') }}"
                                class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i
                                    class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a>
                        </span>
                    @endif
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Module Status</th>
                                <th>Link Validity</th>
                                <th>Expiration Date</th>
                                <th>Total Clicks</th>
                                <th>Receiver E-Mail</th>
                                @if (!isset($customer))
                                    <th>Sender E-Mail</th>
                                @endif
                                {{-- <th>Sharable Links</th>
                            <th>Passcode</th> --}}
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            @foreach ($modulesData as $modules)
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        @if ($modules->is_valid == 'Invalid')
                                            <strong class="text-danger">Expired</strong>
                                        @else
                                            <strong class="text-success">Active</strong>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($modules->is_valid == 'Invalid')
                                            <strong class="text-danger">Invalid</strong>
                                        @else
                                            <strong class="text-success">Valid</strong>
                                        @endif
                                    </td>
                                    <td><strong>{{ date('h:i A, M d, Y', strtotime($modules->validity)) }}</strong></td>
                                    <td><strong>{{ $modules->total_clicks }}</strong></td>
                                    <td>{{ $modules->email_to }}</td>
                                    @if (!isset($customer))
                                        <td>{{ $modules->your_email }}</td>
                                    @endif
                                    {{-- <td><a href="{{ env("CORS_ALLOWED_ORIGINS").$modules->sharable_link }}" target="_blank" >{{ env("CORS_ALLOWED_ORIGINS").$modules->sharable_link }}</a></td>
                            <td><strong>{{ $modules->passcode }}</strong></td> --}}
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                @if (isset($customer))
                                                    <a class="dropdown-item"
                                                        href="{{ route('view.files', ['customer_enc' => $customer->encrypted_id, 'module_id' => $modules->encrypted_id]) }}">
                                                        <i class="bx bx-show me-1"></i> View Files Data
                                                    </a>
                                                @else
                                                    <a class="dropdown-item"
                                                        href="{{ route('view.files', $modules->encrypted_id) }}">
                                                        <i class="bx bx-show me-1"></i> View Files
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>

@endsection

@section('admin-custom-js')
    <script>
        $("#table").DataTable();
    </script>
@endsection
