@extends('admin.layouts.main-layout')
<?php if(!empty($section->encrypted_id)) {
    $title = "Edit Page Section & Page Sub-Section Management";
} else {
    $title = "Add Page Section";
}
?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($section->encrypted_id) ? route('edit.page.section', ["page" => $page_enc_id, "section" => $section->encrypted_id]) : route('add.page.section', $page_enc_id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('edit.page', $page_enc_id) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    @if (session('success'))
                    <div class="alert alert-success alert-dismissible" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @elseif (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                @if(session()->get('role') == 'superadmin')
                                <div class="col-6">
                                    <label for="default_section_name" class="col-form-label">Default Section Name</label>
                                    <input type="text" class="form-control" id="default_section_name" name="default_section_name" value="{{ !empty($section->encrypted_id) ? $section->default_section_name : '' }}" placeholder="Enter Default Name" />
                                </div>
                                @endif
                                <div class="col-6">
                                    <label for="section_title" class="col-form-label">Section Title</label>
                                    <input type="text" class="form-control" id="section_title" name="section_title" value="{{ !empty($section->encrypted_id) ? $section->section_title : '' }}" placeholder="Enter Title" />
                                </div>
                                <div class="col-6">
                                    <label for="section_headline" class="col-form-label">Section Headline</label>
                                    <input type="text" class="form-control" id="section_headline" name="section_headline" value="{{ !empty($section->encrypted_id) ? $section->section_headline : '' }}" placeholder="Enter Headline" />
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($section->encrypted_id) ? htmlspecialchars_decode($section->description) : '' }}</textarea>
                                </div>
                                <div class="col-12">
                                    <label for="button_name" class="col-form-label">Button</label>
                                    <div class="row">
                                        <div class="col-6">
                                            <input type="text" class="form-control" id="button_name" name="button_name" value="{{ !empty($section->encrypted_id) ? $section->button_name : '' }}" placeholder="Enter Name" />
                                        </div>
                                        @if(session()->get('role') == 'superadmin')
                                        <div class="col-6">
                                            <input type="text" class="form-control" id="button_link" name="button_link" value="{{ !empty($section->encrypted_id) ? $section->button_link : '' }}" placeholder="Enter Link" />
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-6">
                                <label for="section_image" class="col-form-label">Section Image</label>
                                @if(!empty($section->encrypted_id) && !empty($section->section_image))
                                <div class="my-3">
                                    <img src="{{ asset($section->section_image) }}" alt="Section_Image" class="rounded" height="50px" width="50px">
                                </div>
                                @endif
                                <input class="form-control" type="file" id="section_image" name="section_image" />
                            </div>
                            <div class="col-6">
                                <label for="more_images" class="col-form-label">More Images</label>
                                @if(!empty($section->encrypted_id) && !empty($section->more_images))
                                <div class="my-3">
                                    @php
                                        $more_images = json_decode($section->more_images);
                                    @endphp
                                    @if (!empty($section->more_images))
                                        @foreach($more_images as $image)
                                        <img src="{{ asset($image) }}" alt="More_Images" class="rounded" height="50px" width="50px">
                                        @endforeach
                                    @endif
                                </div>
                                @endif
                                <input class="form-control" type="file" id="more_images" name="more_images[]" accept=".jpg, .jpeg, .png, .webp" multiple />
                            </div>
                            <div class="col-6">
                                <label for="section_video" class="col-form-label">Section Video</label>
                                @if(!empty($section->encrypted_id) && !empty($section->section_video))
                                <div class="my-3">
                                    <video width="200" controls>
                                        <source src="{{ asset($section->section_video) }}" loop="true" autoplay muted>
                                    </video>
                                </div>
                                @endif
                                <input class="form-control" type="file" id="section_video" name="section_video" accept=".mp4,.mov,.avi,.mkv,.webm" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($section->encrypted_id) ? 'Update Section' : 'Add Section' }}" class="btn btn-primary" />
                        <a href="{{ route('edit.page', $page_enc_id) }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
        @if(!empty($section->encrypted_id))
        <hr>
        <!-- Hoverable Table rows -->
        <div class="card mt-4">
            <h5 class="card-header">Sub-Section Management
                {{-- @if(session()->get('role') == 'superadmin') --}}
                <a href="{{ route('add.page.subsection', ["page" => $page_enc_id, "section" => $section->encrypted_id]) }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                {{-- @endif --}}
                <a href="{{ route('get.sections.page', ["page" => $page_enc_id, "section" => $section->encrypted_id]) }}" class="btn btn-primary float-end me-2">Sections Sequence</a>
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="subsection-table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Sub-Section Title</th>
                            <th>Sub-Section Headline</th>
                            @if(session()->get('role') == 'superadmin')
                            <th>Sub-Section Position</th>
                            @endif
                            <th>Sub-Section Image</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        @foreach($subSectionsData as $subSections)
                        <tr>
                            <td><?= $sno; ?></td>
                            <td>{{ $subSections->section_title }}</td>
                            <td>{{ $subSections->section_headline }}</td>
                            @if(session()->get('role') == 'superadmin')
                            <td>{{ $subSections->position_order }}</td>
                            @endif
                            <td>
                                @if(!empty($subSections->section_image))
                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-md pull-up" title="{{ $subSections->section_headline }}" >
                                        <img src="{{ asset($subSections->section_image) }}" alt="Sub_Section_Image" class="rounded-circle" />
                                    </li>
                                </ul>
                                @endif
                            </td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $subSections->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $subSections->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('edit.page.subsection', ["page" => $page_enc_id, "section" => $section->encrypted_id, "subsection" => $subSections->encrypted_id]) }}" ><i class="bx bx-edit-alt me-1"></i> Edit</a>
                                        {{-- @if(session()->get('role') == 'superadmin') --}}
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $subSections->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                        {{-- @endif --}}
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
        @endif
    </div>
</div>
@endsection

@section('admin-custom-js')
<script>
    $("#subsection-table").DataTable();
</script>
@endsection
