@extends('admin.layouts.main-layout')

<?php $title = 'Add/Update Project Details Content'; ?>

@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form action="{{ route('manage.project.details.contents', ['project' => $projectId]) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.projects') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @elseif (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-3">
                                    <h5 class="card-header">Project Details</h5>
                                    <div class="card-body">
                                        <div id="project-details"></div>
                                        <span class="float-end"><button type="button" id="add-detail-row"
                                                class="btn rounded-pill btn-icon btn-primary float-end"
                                                style="font-size: 1.7em;">+</button></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit" value="Update Project Details" class="btn btn-primary" />
                            <a href="{{ route('manage.projects') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let projectDetail = 1;

            // Function to add a new row
            function addProjectDetailRow(item = {}) {

                // Create the first row (Section Headline)
                const row1 = document.createElement('div');
                row1.className = 'row mb-3';

                // Hidden input for ID
                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'detail_ids[]';
                idInput.value = item.detail_id || '';
                row1.appendChild(idInput);

                // Input for Section Headline
                const col1 = document.createElement('div');
                col1.className = 'col-sm-3';

                const input1 = document.createElement('input');
                input1.type = 'text';
                input1.className = 'form-control';
                input1.id = `projectDetail-${projectDetail}`;
                input1.name = 'detail_titles[]';
                input1.placeholder = 'Enter Title';
                input1.value = item.detail_title || '';
                input1.required = true;

                // Prevent removal of the required attribute
                Object.defineProperty(input1, 'required', {
                    configurable: false,
                    writable: false,
                    value: true,
                });

                const col2 = document.createElement('div');
                col2.className = 'col-sm-8';

                const input11 = document.createElement('input');
                input11.type = 'text';
                input11.className = 'form-control';
                input11.id = `projectDetail-${projectDetail}`;
                input11.name = 'detail_texts[]';
                input11.placeholder = 'Enter Text';
                input11.value = item.detail_text || '';
                input11.required = true;

                // Input for Section Headline
                const col3 = document.createElement('div');
                col3.className = 'col-sm-1';

                // Button div
                const buttonsDiv = document.createElement('div');
                buttonsDiv.classList.add('float-end');

                // Remove Button
                const removeButton = document.createElement('button');
                removeButton.type = 'button';
                removeButton.classList.add('btn', 'btn-danger', 'btn-icon', 'rounded-pill');
                removeButton.innerHTML = `<i class="bx bx-trash"></i>`;
                removeButton.onclick = function() {
                    if (item && item.detail_id) {
                        $.ajax({
                            url: "{{ route('delete.project.details') }}",
                            method: "POST",
                            data: {
                                'detail': item.detail_id,
                                '_token': '{{ csrf_token() }}'
                            },
                            success: function(res) {
                                row1.remove();
                            }
                        });
                    } else {
                        row1.remove();
                    }
                };
                buttonsDiv.appendChild(removeButton);

                // Append input to column and label + column to row
                col1.appendChild(input1);
                col2.appendChild(input11);
                col3.appendChild(buttonsDiv);
                row1.appendChild(col1);
                row1.appendChild(col2);
                row1.appendChild(col3);

                // Append the new row to the form
                document.getElementById('project-details').appendChild(row1);

                projectDetail++;
            }

            // Fetch data from the server (get_sub_section_data.php) and add rows
            fetch("{{ route('get.project.details.contents', $projectId) }}")
                .then(response => response.json())
                .then(data => {
                    data.forEach(item => {
                        addProjectDetailRow(item);
                    });
                });

            // Event listener to add a new blank row when "Add Row" button is clicked
            document.getElementById('add-detail-row').addEventListener('click', () => {
                addProjectDetailRow();
            });
        });
    </script>

@endsection
