@extends('admin.layouts.main-layout')
@php
    if (!empty($type->encrypted_id)) {
        $title = 'Edit Type';
    } else {
        $title = 'Add Type';
    }
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($type->encrypted_id) ? route('edit.type', ['type' => $type->encrypted_id]) : route('add.type') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.types') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="type_name" class="col-form-label">Type Name</label>
                                        <input type="text" class="form-control" id="type_name" name="type_name"
                                            value="{{ !empty($type->encrypted_id) ? $type->type_name : '' }}"
                                            placeholder="Enter Name" />
                                        @error('type_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="submit" value="{{ !empty($type->encrypted_id) ? 'Update Type' : 'Add Type' }}"
                            class="btn btn-primary" />
                        <a href="{{ route('manage.types') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    {{--
    <script>
        function getUrl(field_id) {
            let errors = 0;
            let type_name = $.trim($("#" + field_id).val());
            let id = "{{ !empty($type->encrypted_id) ? $type->encrypted_id : '' }}";
            // Replace '/' and spaces with '-'
            let type_url = type_name.replace(/[\/\s]+/g, '-').toLowerCase();
            if (type_name == "" || type_name == undefined || type_name == null) {
                errors += 1;
            }
            if (type_url == "" || type_url == undefined || type_url == null) {
                errors += 1;
            }
            if (errors > 0) {
                $("#type_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                type_url = type_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');
                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.type.link', ['type_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', type_url)
                    .replace('__ID__', id);
                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("type_url").value =
                        data; // Update input field with returned type_url
                        // $("#type_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script>
    --}}
@endsection
