@extends('admin.layouts.main-layout')

@php
    if (isset($customer)) {
        $title = 'Manage Files Data regarding ' . $customer->first_name . ' ' . $customer->last_name;
    } else {
        $title = 'Manage Files Data';
    }
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">{{ $title }}<span class="float-end">
                        @if ($customer)
                            <a href="{{ route('view.customer.data', $customer->encrypted_id) }}"
                                class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i
                                    class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a>
                    </span>
                @else
                    <a href="{{ route('manage.guest.users.data') }}"
                        class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                            style="font-size: 1.7rem;"></i></a></span>
                    @endif
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>File Status</th>
                                <th>Total Downloads</th>
                                <th>File Name</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            @foreach ($filesData as $files)
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        @if ($files->file_status == 'removed')
                                            <strong class="text-danger">Removed</strong>
                                        @else
                                            <strong class="text-success">Valid</strong>
                                        @endif
                                    </td>
                                    <td><strong>{{ $files->total_downloads }}</strong></td>
                                    <td>{{ $files->encrypted_name }}</td>
                                </tr>
                                <?php $sno++; ?>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>

@endsection

@section('admin-custom-js')
    <script>
        $("#table").DataTable();
    </script>
@endsection
