<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\InvoicesController;
use App\Http\Controllers\CustomersPaymentsController;
use App\Http\Controllers\EnquiriesController;
use App\Http\Controllers\FilesController;
use App\Http\Controllers\SitePagesController;
use App\Http\Controllers\WebRTCController;
use App\Http\Controllers\WebsiteController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/check-site-status', [WebsiteController::class, 'checkSiteStatus']);
// Route::get('/get-website-data', [WebsiteController::class, 'getWebsiteData']);

Route::post('/signup', [AuthController::class, 'signup']);
Route::post('/login', [AuthController::class, 'login']);
Route::match(['get', 'post'], '/get-and-update-customer-profile', [AuthController::class, 'getAndUpdateCustomerProfile']);
Route::post('/update-customer-password', [AuthController::class, 'updateCustomerPassword']);
Route::post('/check-email-and-send-link', [AuthController::class, 'checkEmailAndSendLink']);
Route::post('/check-reset-link', [AuthController::class, 'checkResetLink']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);
Route::prefix('invoices')->group(function () {
    // Route::get('/', [InvoicesController::class, 'index']);
    Route::get('/{invoice_number}', [InvoicesController::class, 'show'])->name('invoice.show');
    Route::get('/{id}/download', [InvoicesController::class, 'download'])->name('invoice.download');
});

Route::get('/get-company-data', [SitePagesController::class, 'getCompanyData']);
// Route::get('/get-header-links', [SitePagesController::class, 'getHeaderLinks']);
// Route::get('/get-footer-links', [SitePagesController::class, 'getFooterLinks']);
Route::post('/contact-enquiry-data-save', [SitePagesController::class, 'contactEnquiryDataSave']);
Route::get('/get-page', [SitePagesController::class, 'getPage']);
Route::get('/get-page-section', [SitePagesController::class, 'getPageSection']);
// Route::get('/get-page-sections', [SitePagesController::class, 'getPageSections']);
Route::get('/get-page-subsections', [SitePagesController::class, 'getPageSubsections']);

Route::get('/get-banners', [SitePagesController::class, 'getBanners']);
// Route::get('/get-partners', [SitePagesController::class, 'getPartners']);
// Route::get('/get-features', [SitePagesController::class, 'getFeatures']);
Route::get('/get-faqs', [SitePagesController::class, 'getFaqs']);
Route::get('/get-testimonials', [SitePagesController::class, 'getTestimonials']);
// Route::get('/get-plans', [SitePagesController::class, 'getPlans']);
Route::get('/get-blogs', [SitePagesController::class, 'getBlogs']);
Route::get('/get-blog/{blog_url}', [SitePagesController::class, 'getBlog']);
Route::get('/get-cover-pages', [SitePagesController::class, 'getCoverPages']);
Route::get('/get-free-downloads', [SitePagesController::class, 'getFreeDownloads']);

Route::get('/get-assignment-categories-courses/{assignment_type}', [SitePagesController::class, 'getAssignmentCategoriesCourses']);
Route::get('/get-course-assignments/{type}/{course_slug}', [SitePagesController::class, 'getCourseAssignments']);
Route::get('/get-single-course-assignment/{course_slug}/{assignment_slug}', [SitePagesController::class, 'getSingleCourseAssignment']);
Route::get('/get-assignment-cards', [SitePagesController::class, 'getAssignmentCards']);

Route::get('/get-guess-paper-categories-courses', [SitePagesController::class, 'getGuessPaperCategoriesCourses']);
Route::get('/get-course-guess-papers/{course_slug}', [SitePagesController::class, 'getCourseGuessPapers']);
Route::get('/get-single-course-guess-paper/{course_slug}/{guess_paper_slug}', [SitePagesController::class, 'getSingleCourseGuessPaper']);

Route::get('/get-project-categories-courses', [SitePagesController::class, 'getProjectCategoriesCourses']);
Route::get('/get-course-projects/{course_slug}', [SitePagesController::class, 'getCourseProjects']);
Route::get('/get-single-course-project/{course_slug}/{project_slug}', [SitePagesController::class, 'getSingleCourseProject']);
Route::get('/get-project-cards', [SitePagesController::class, 'getProjectCards']);

Route::get('/get-handwritten-data', [SitePagesController::class, 'getHandwrittenData']);
Route::post('/handwritten-data-save', [SitePagesController::class, 'handwrittenDataSave']);

Route::get('/cart-user-list', [SitePagesController::class, 'cartUserList']);
Route::post('/cart-merge', [SitePagesController::class, 'merge']);
Route::post('/cart-add', [SitePagesController::class, 'add']);
Route::post('/cart-remove', [SitePagesController::class, 'remove']);
Route::post('/cart-update', [SitePagesController::class, 'update']);
Route::get('/cart-clear', [SitePagesController::class, 'cartUserClear']);

Route::post('/place-order', [SitePagesController::class, 'placeOrder']);
Route::get('/get-customer-payments', [SitePagesController::class, 'getCustomerPayments']);

Route::get('/get-customer-cards', [SitePagesController::class, 'getCustomerCards']);
Route::post('/add-customer-card', [SitePagesController::class, 'addCustomerCard']);
Route::put('/update-customer-card/{encrypted_id}', [SitePagesController::class, 'updateCustomerCard']);
Route::delete('/delete-customer-card/{encrypted_id}', [SitePagesController::class, 'deleteCustomerCard']);
Route::patch('/set-default-card/{encrypted_id}', [SitePagesController::class, 'setDefaultCard']);

Route::get('/get-customer-orders', [SitePagesController::class, 'getCustomerOrders']);
