<?php if (!empty($banner->encrypted_id)) {
    $title = 'Edit Banner';
} else {
    $title = 'Add Banner';
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="<?php echo e(!empty($banner->encrypted_id) ? route('edit.banner', $banner->encrypted_id) : route('add.banner')); ?>"
                method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="<?php echo e(route('manage.banners')); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="banner_headline" class="col-form-label">Banner Headline</label>
                                        <input type="text" class="form-control" id="banner_headline"
                                            name="banner_headline"
                                            value="<?php echo e(!empty($banner->encrypted_id) ? $banner->banner_headline : old('banner_headline')); ?>"
                                            placeholder="Enter Headline" />
                                        <?php $__errorArgs = ['banner_headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="banner_title" class="col-form-label">Banner Title</label>
                                        <input type="text" class="form-control" id="banner_title" name="banner_title"
                                            value="<?php echo e(!empty($banner->encrypted_id) ? $banner->banner_title : old('banner_title')); ?>"
                                            placeholder="Enter Title" />
                                        <?php $__errorArgs = ['banner_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea name="description" id="description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Description"><?php echo e(!empty($banner->encrypted_id) ? htmlspecialchars_decode($banner->description) : old('description')); ?></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="button_name" class="col-form-label">Button</label>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="button_name" name="button_name"
                                                value="<?php echo e(!empty($banner->encrypted_id) ? $banner->button_name : old('button_name')); ?>"
                                                placeholder="Enter Name" />
                                        </div>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="button_link" name="button_link"
                                                value="<?php echo e(!empty($banner->encrypted_id) ? $banner->button_link : old('button_link')); ?>"
                                                placeholder="Enter Link" />
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label for="other_button_name" class="col-form-label">Other Button</label>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="other_button_name"
                                                name="other_button_name"
                                                value="<?php echo e(!empty($banner->encrypted_id) ? $banner->other_button_name : old('other_button_name')); ?>"
                                                placeholder="Enter Name" />
                                        </div>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="other_button_link"
                                                name="other_button_link"
                                                value="<?php echo e(!empty($banner->encrypted_id) ? $banner->other_button_link : old('other_button_link')); ?>"
                                                placeholder="Enter Link" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="card mb-3">
                                    <div class="card-body row">
                                        <div class="col-12">
                                            <label for="banner_image" class="col-form-label">Banner Image</label>
                                            <?php if(!empty($banner->encrypted_id) && !empty($banner->banner_image)): ?>
                                                <div class="my-3">
                                                    <div style="display: inline-block; position: relative; margin: 5px;">
                                                        <img src="<?php echo e(asset($banner->banner_image)); ?>" alt="Banner_Image"
                                                            class="rounded" height="60px" width="60px"
                                                            style="object-fit: cover;">
                                                        <button
                                                            style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <input class="form-control" type="file" id="banner_image"
                                                name="banner_image" accept="image/*" />
                                            <?php $__errorArgs = ['banner_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="text-danger"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="<?php echo e(!empty($banner->encrypted_id) ? 'Update Banner' : 'Add Banner'); ?>"
                                class="btn btn-primary" />
                            <a href="<?php echo e(route('manage.banners')); ?>" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/banner-ops.blade.php ENDPATH**/ ?>