<?php if (!empty($subject->encrypted_id)) {
    $title = 'Edit Subject';
} else {
    $title = 'Add Subject';
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="<?php echo e(!empty($subject->encrypted_id) ? route('edit.subject', $subject->encrypted_id) : route('add.subject')); ?>"
                method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="<?php echo e(route('manage.subjects')); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        <label for="course_ids" class="form-label">Course(s)</label>
                                        <select name="course_ids[]" id="course_ids" class="form-select" multiple>
                                            <?php
                                                $selectedCourses = !empty($subject->encrypted_id)
                                                    ? $subject->courses->pluck('id')->toArray()
                                                    : [];
                                            ?>
                                            <?php $__currentLoopData = $all_subject_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject_course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($subject_course->encrypted_id); ?>"
                                                    <?php echo e(in_array($subject_course->id, $selectedCourses) ? 'selected' : ''); ?>>
                                                    <?php echo e($subject_course->course_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['course_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="subject_name" class="col-form-label">Subject Name</label>
                                        <input type="text" class="form-control" id="subject_name" name="subject_name"
                                            value="<?php echo e(!empty($subject->encrypted_id) ? $subject->subject_name : old('subject_name')); ?>"
                                            placeholder="Enter Name" onblur="getUrl(this.id)" />
                                        
                                        <?php $__errorArgs = ['subject_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="subject_code" class="col-form-label">Subject Code</label>
                                        <input type="text" class="form-control" id="subject_code" name="subject_code"
                                            value="<?php echo e(!empty($subject->encrypted_id) ? $subject->subject_code : old('subject_code')); ?>"
                                            placeholder="Enter Code" />
                                        <?php $__errorArgs = ['subject_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="course_year" class="col-form-label">Course Year</label>
                                        <select class="form-select" id="course_year" name="course_year" required>
                                            <option value="" disabled <?php if(old('course_year', $subject->course_year ?? '') === ''): echo 'selected'; endif; ?>>
                                                -- Select Year --
                                            </option>

                                            <?php for($i = 1; $i <= 12; $i++): ?>
                                                <?php
                                                    $value = "Year-$i";
                                                ?>

                                                <option
                                                    value="<?php echo e($value); ?>"
                                                    <?php if(old('course_year', $subject->course_year ?? '') == $value): echo 'selected'; endif; ?>
                                                >
                                                    Year-<?php echo e($i); ?>

                                                </option>
                                            <?php endfor; ?>
                                        </select>
                                        <?php $__errorArgs = ['course_year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="semesters" class="form-label">Semester(s)</label>
                                        <select name="semesters[]" id="semesters" class="form-select" multiple>
                                            <?php
                                                $selectedSemesters = old('semesters', $subject->semesters ?? []);
                                            ?>
                                            <?php for($i = 1; $i <= 24; $i++): ?>
                                                <?php $value = "Semester-$i"; ?>
                                                <option value="<?php echo e($value); ?>"
                                                    <?php echo e(in_array($value, $selectedSemesters ?? []) ? 'selected' : ''); ?>>
                                                    Semester-<?php echo e($i); ?>

                                                </option>
                                            <?php endfor; ?>
                                        </select>
                                        <?php $__errorArgs = ['semesters'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="<?php echo e(!empty($subject->encrypted_id) ? 'Update Subject' : 'Add Subject'); ?>"
                                class="btn btn-primary" />
                            <a href="<?php echo e(route('manage.subjects')); ?>" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    <script>
        new MultiSelectTag('course_ids');
        new MultiSelectTag('semesters');
    </script>

    

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/subject-ops.blade.php ENDPATH**/ ?>