<?php $__env->startSection('title', 'Manage Subjects'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php elseif(session('error')): ?>
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">Manage Subjects
                    <span class="float-end">
                        <a href="<?php echo e(route('add.subject')); ?>"
                            class="btn rounded-pill btn-icon btn-outline-primary float-end ms-2"
                            style="font-size: 1.7em;">+</a>
                        
                    </span>
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="subject-table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                
                                <th>Course Code(s)</th>
                                <th>Subject Code</th>
                                <th>Subject Name</th>
                                <th>Subject Position</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>

                            <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($sno); ?>.</td>

                                    <td>
                                        
                                        <?php echo collect($subject->courses)->pluck('course_code')->implode(', <br>'); ?>

                                    </td>

                                    <td><strong><?php echo e($subject->subject_code); ?></strong></td>

                                    <td><?php echo e($subject->subject_name); ?></td>

                                    <td><?php echo e($subject->position_order); ?></td>

                                    <td>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input status_button"
                                                onclick="change_status('<?php echo e($model); ?>', <?php echo e($sno); ?>, '<?php echo e($subject->encrypted_id); ?>');"
                                                type="checkbox" id="status<?php echo e($sno); ?>"
                                                <?php echo e($subject->status == 'active' ? 'checked' : ''); ?> />
                                        </div>
                                    </td>

                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>

                                            <div class="dropdown-menu">
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('edit.subject', $subject->encrypted_id)); ?>">
                                                    <i class="bx bx-edit-alt me-1"></i> Edit
                                                </a>

                                                <button class="dropdown-item"
                                                    onclick="delete_item('<?php echo e($model); ?>', '<?php echo e($subject->encrypted_id); ?>');">
                                                    <i class="bx bx-trash me-1"></i> Delete
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>

                                <?php $sno++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $("#subject-table").DataTable();

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/manage_subjects.blade.php ENDPATH**/ ?>