<?php $title = 'Add/Update Assignment Details Content'; ?>

<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form action="<?php echo e(route('manage.assignment.details.contents', ['assignment' => $assignmentId])); ?>" method="POST"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="<?php echo e(route('manage.assignments')); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success alert-dismissible" role="alert">
                                <?php echo e(session('success')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php elseif(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-3">
                                    <h5 class="card-header">Assignment Details</h5>
                                    <div class="card-body">
                                        <div id="assignment-details"></div>
                                        <span class="float-end"><button type="button" id="add-detail-row"
                                                class="btn rounded-pill btn-icon btn-primary float-end"
                                                style="font-size: 1.7em;">+</button></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit" value="Update Assignment Details" class="btn btn-primary" />
                            <a href="<?php echo e(route('manage.assignments')); ?>" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let assignmentDetail = 1;

            // Function to add a new row
            function addAssignmentDetailRow(item = {}) {

                // Create the first row (Section Headline)
                const row1 = document.createElement('div');
                row1.className = 'row mb-3';

                // Hidden input for ID
                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'detail_ids[]';
                idInput.value = item.detail_id || '';
                row1.appendChild(idInput);

                // Input for Section Headline
                const col1 = document.createElement('div');
                col1.className = 'col-sm-3';

                const input1 = document.createElement('input');
                input1.type = 'text';
                input1.className = 'form-control';
                input1.id = `assignmentDetail-${assignmentDetail}`;
                input1.name = 'detail_titles[]';
                input1.placeholder = 'Enter Title';
                input1.value = item.detail_title || '';
                input1.required = true;

                // Prevent removal of the required attribute
                Object.defineProperty(input1, 'required', {
                    configurable: false,
                    writable: false,
                    value: true,
                });

                const col2 = document.createElement('div');
                col2.className = 'col-sm-8';

                const input11 = document.createElement('input');
                input11.type = 'text';
                input11.className = 'form-control';
                input11.id = `assignmentDetail-${assignmentDetail}`;
                input11.name = 'detail_texts[]';
                input11.placeholder = 'Enter Text';
                input11.value = item.detail_text || '';
                input11.required = true;

                // Input for Section Headline
                const col3 = document.createElement('div');
                col3.className = 'col-sm-1';

                // Button div
                const buttonsDiv = document.createElement('div');
                buttonsDiv.classList.add('float-end');

                // Remove Button
                const removeButton = document.createElement('button');
                removeButton.type = 'button';
                removeButton.classList.add('btn', 'btn-danger', 'btn-icon', 'rounded-pill');
                removeButton.innerHTML = `<i class="bx bx-trash"></i>`;
                removeButton.onclick = function() {
                    if (item && item.detail_id) {
                        $.ajax({
                            url: "<?php echo e(route('delete.assignment.details')); ?>",
                            method: "POST",
                            data: {
                                'detail': item.detail_id,
                                '_token': '<?php echo e(csrf_token()); ?>'
                            },
                            success: function(res) {
                                row1.remove();
                            }
                        });
                    } else {
                        row1.remove();
                    }
                };
                buttonsDiv.appendChild(removeButton);

                // Append input to column and label + column to row
                col1.appendChild(input1);
                col2.appendChild(input11);
                col3.appendChild(buttonsDiv);
                row1.appendChild(col1);
                row1.appendChild(col2);
                row1.appendChild(col3);

                // Append the new row to the form
                document.getElementById('assignment-details').appendChild(row1);

                assignmentDetail++;
            }

            // Fetch data from the server (get_sub_section_data.php) and add rows
            fetch("<?php echo e(route('get.assignment.details.contents', $assignmentId)); ?>")
                .then(response => response.json())
                .then(data => {
                    data.forEach(item => {
                        addAssignmentDetailRow(item);
                    });
                });

            // Event listener to add a new blank row when "Add Row" button is clicked
            document.getElementById('add-detail-row').addEventListener('click', () => {
                addAssignmentDetailRow();
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/assignment_other_details.blade.php ENDPATH**/ ?>